#！/bin/bash
# install script
SYSTEM_INPUTMETHOD_DIR="/Library/Input Methods"
SOGOU_INPUT_APP_PATH="/Library/Input Methods/SogouInput.app"
SOGOU_SERVICES_PATH="/Library/LaunchAgents/com.sogou.SogouServices.plist"
SOGOU_TASKMANAGER_PATH="/Library/LaunchAgents/com.sogou.SogouTaskManager.plist"
SOGOU_QUICKLOOK_PATH="/Library/QuickLook/SogouSkinFileQuickLook.qlgenerator"
REINSTALL_FLAG="$HOME/Library/Caches/com.sogou.installType"
SOGOU_CHARACTER_APP_PLIST_STRING="/Applications/SogouCharacterViewer.app/Contents/Resources/en.lproj/InfoPlist.strings"
TMP_PATH="/tmp/characterInfo"

LOG_PATH="/tmp/imeInstll.log"

#get current login username
echo ~/Desktop > /tmp/UserName
curUser=`/usr/bin/awk -F "/" '{print $3}' /tmp/UserName`

rm -rf $LOG_PATH
echo "$(date +%s) get current login username : $curUser" >> $LOG_PATH

#--------------前期工作--------------#
#杀掉相关进程

killall SkinManager
killall SogouPreference
killall -9 SogouHelper
killall SGEmojiPanelTool
killall SGAssistPanel
killall SGPicFaceTool
killall SGInputStatPanel
killall SGInputAssistant
killall SogouTextRecognition
killall SGSkinManager
sudo killall -9 SogouInput

echo "$(date +%s) kill process : SkinManager SogouPreference SogouHelper SGEmojiPanelTool SGAssistPanel SGPicFaceTool" >> $LOG_PATH

echo "$(date +%s) param1 : $1" >> $LOG_PATH
echo "$(date +%s) param5 : $5" >> $LOG_PATH

ps -A | awk -F " " '{print $1,$5;printf("\n")}' > /tmp/process
sed -n 's/Methods\/SogouInput\.app\/Contents\/SogouCharacterViewer\.app\/Contents\/MacOS\/SogouCharacterViewer//p' /tmp/process | xargs kill -9
rm -rf /tmp/process

echo "$(date +%s) kill process : SogouCharacterViewer" >> $LOG_PATH

#标志位
if [ -f "$REINSTALL_FLAG"  ]; then
    rm -rf "$REINSTALL_FLAG"
fi

if [ -d "$SOGOU_INPUT_APP_PATH" ]; then
    echo 2 >> "$REINSTALL_FLAG"
else
    echo 1 >> "$REINSTALL_FLAG"
fi

echo "$(date +%s) write reinstall flag to file : $REINSTALL_FLAG" >> $LOG_PATH

#unload之前旧的服务
open -a /bin/launchctl --args unload ~/Library/LaunchAgents/com.sogou.SogouTaskManager.plist

#清理目录
rm -rf /Library/Input\ Methods/SogouInput.app/Contents;
rm -rf /Library/QuickLook/SogouSkinFileQuickLook.qlgenerator;
rm -rf /Applications/SkinManager.app/;
rm -rf /Library/LaunchAgents/com.sogou.SogouServices.plist;
rm -rf /Library/LaunchAgents/com.sogou.SogouTaskManager.plist;
rm -rf ~/Library/LaunchAgents/com.sogou.SogouTaskManager.plist;

echo "$(date +%s) clear install directory : SogouInput.app/Contents SogouSkinFileQuickLook SkinManager.app SogouServices.plist SogouTaskManager.plist"  >> $LOG_PATH

#如果搜狗表情app不是从store来的
#iconv -f UTF-16 -t UTF-8 ${SOGOU_CHARACTER_APP_PLIST_STRING} > ${TMP_PATH}
#if [ -f "${TMP_PATH}" ] && ! grep -q Lite ${TMP_PATH}; then
#    rm -rf /Applications/SogouCharacterViewer.app/;
#    killall SogouCharacterViewer
#fi

rm -rf ${TMP_PATH}

echo "$(date +%s) remove tmp path : $TMP_PATH" >> $LOG_PATH

#-----拷贝用户目录--------

if [ "$1" = "1" ] ;then
	rm -rf ~/Library/Application\ Support/Sogou/InputMethod
	mv ~/Library/Input\ Methods/Sogou ~/Library/Application\ Support/Sogou/InputMethod
else
	rm -rf ~/Library/Input\ Methods/Sogou
fi

echo "$(date +%s) move user directory finish" >> $LOG_PATH

#--------------安装--------------#
CUR_DIR=$(cd "$(dirname "$0")"; pwd)

# 先删除之前旧的文件夹，确保覆盖安装拷贝新的
rm -rf ~/Library/Application\ Support/Sogou/Plugins/
mkdir ~/Library/Application\ Support/Sogou/Plugins/
chmod 755 ~/Library/Application\ Support/Sogou/Plugins/
INSTALL_PATH="$CUR_DIR/SogouInput.app/Contents"

# 将偏好设置、输入统计相关进程拷贝到用户目录
cp -aR "$INSTALL_PATH/SogouPreference.app" ~/Library/Application\ Support/Sogou/Plugins/
cp -aR "$INSTALL_PATH/SGInputStatPanel.app" ~/Library/Application\ Support/Sogou/Plugins/
cp -aR "$INSTALL_PATH/SGAssistPanel.app" ~/Library/Application\ Support/Sogou/Plugins/
cp -aR "$INSTALL_PATH/SGEmojiPanelTool.app" ~/Library/Application\ Support/Sogou/Plugins/
cp -aR "$INSTALL_PATH/SGPicFaceTool.app" ~/Library/Application\ Support/Sogou/Plugins/
cp -aR "$INSTALL_PATH/SogouTextRecognition.app" ~/Library/Application\ Support/Sogou/Plugins/

if [ -d "$SOGOU_INPUT_APP_PATH" ]; then
    echo "$(date +%s) start reinstall " >> $LOG_PATH
    sudo chmod 755 "$SOGOU_INPUT_APP_PATH"
    TMP_SOURCE="$CUR_DIR/SogouInput.app/Contents"
    TMP_TARGET="$SOGOU_INPUT_APP_PATH/"
    
    echo "$(date +%s) file1 "$TMP_SOURCE" " >> $LOG_PATH
    echo "$(date +%s) file2 "$TMP_TARGET" " >> $LOG_PATH

    rm -rf "$SOGOU_INPUT_APP_PATH/Contents"
    cp -aR "$TMP_SOURCE" "$TMP_TARGET"
else
    echo "$(date +%s) start new install " >> $LOG_PATH
    mv "$CUR_DIR/SogouInput.app" "$SYSTEM_INPUTMETHOD_DIR"
fi

echo "$(date +%s) install tmpSource : $TMP_SOURCE" >> $LOG_PATH
echo "$(date +%s) install ime : $CUR_DIR" >> $LOG_PATH
echo "$(date +%s) install ime : copy files finish" >> $LOG_PATH

mv "$CUR_DIR/SogouSkinFileQuickLook.qlgenerator" "$SOGOU_QUICKLOOK_PATH"
mv "$CUR_DIR/com.sogou.SogouServices.plist" "$SOGOU_SERVICES_PATH"
mv "$CUR_DIR/com.sogou.SogouTaskManager.plist" "$SOGOU_TASKMANAGER_PATH"

echo "$(date +%s) move SogouSkinFileQuickLook com.sogou.SogouServices.plist com.sogou.SogouTaskManager.plist" >> $LOG_PATH


sudo chmod 755 "$SOGOU_INPUT_APP_PATH"
sudo chmod 755 "$SOGOU_INPUT_APP_PATH/Contents"

#remove extension attribute : com.apple.quarantine
sudo xattr -d -r com.apple.quarantine "$SOGOU_INPUT_APP_PATH"
#--------------增加删除权限--------------#
sudo xattr -d com.apple.quarantine "$SOGOU_INPUT_APP_PATH"

echo "$(date +%s) remove xattr : com.apple.quarantine" >> $LOG_PATH

#--------------修改权限--------------#
chown $curUser:staff ~/Library/Input\ Methods/
cd "$CUR_DIR"
chmod -R 755 ~/Library/Application\ Support/Sogou/InputMethod
chown $curUser:staff ~/Library/Application\ Support/Sogou/Plugins/
chmod -R 755 ~/Library/Application\ Support/Sogou/Plugins

./SetFile -a l ~/Library
./SetFile -a l ~/Library/Application\ Support
./SetFile -a l ~/Library/Application\ Support/Sogou
./SetFile -a l ~/Library/Application\ Support/Sogou/InputMethod
./SetFile -a l ~/Library/Application\ Support/Sogou/Plugins
sudo chown -R root:staff "$SOGOU_INPUT_APP_PATH"
sudo chmod -R 775 "$SOGOU_INPUT_APP_PATH"
chmod -R 775 /Library/QuickLook/SogouSkinFileQuickLook.qlgenerator
chown -R root:staff /Library/QuickLook/SogouSkinFileQuickLook.qlgenerator
ver=`uname -r | cut -d. -f1-2`
if [ $ver > 12 ]; then
	chown root:wheel /Library/QuickLook
else
	chmod root:admin /Library/QuickLook
fi
rm -rf /tmp/UserName

echo "$(date +%s) modify SogouInput permissions" >> $LOG_PATH

#--------------解压词库--------------#

#cd /Library/Input\ Methods/SogouInput.app/Contents/Resources/
#./SysDictUnzip sysmodel.bin sgim_core.bin

#--------------后期清理--------------#
sudo chmod +rx "/Library/Input Methods"
sudo chmod -R 777 "$SOGOU_INPUT_APP_PATH/Contents/Resources"
chown root:wheel "/Library/LaunchAgents/com.sogou.SogouServices.plist"
chown root:wheel "/Library/LaunchAgents/com.sogou.SogouTaskManager.plist"

echo "$(date +%s) modify com.sogou.SogouServices.plist com.sogou.SogouTaskManager.plist permissions" >> $LOG_PATH

sudo killall -9 SogouTaskManager
sudo killall -9 SogouServices
sudo killall -9 SogouInput

echo "$(date +%s) kill process : SogouTaskManager SogouServices SogouInput" >> $LOG_PATH

open -a /bin/launchctl --args load -wF /Library/LaunchAgents/com.sogou.SogouServices.plist
open -a /bin/launchctl --args load -wF /Library/LaunchAgents/com.sogou.SogouTaskManager.plist

echo "$(date +%s) register service : launchctl com.sogou.SogouServices.plist and com.sogou.SogouTaskManager.plist" >> $LOG_PATH

#open -a /Library/Input\ Methods/SogouInput.app/Contents/SogouHelper --args selectNow
#open -a /Library/Input\ Methods/SogouInput.app/Contents/SogouHelper --args select

# associate .ssf with "SkinManager".app


#/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support/lsregister -kill -domain local -domain system -domain user;
/usr/bin/qlmanage -r
/usr/bin/qlmanage -r cache

echo "$(date +%s) reset Quick Look Server" >> $LOG_PATH

#for associate ssf
#/Library/Input\ Methods/SogouInput.app/Contents/SogouPreference.app/Contents/MacOS/SogouPreference -associateSSF
#open -a /Library/Input\ Methods/SogouInput.app/Contents/SogouPreference.app/Contents/MacOS/SogouPreference --args -associateSSF

cp -f /Library/Input\ Methods/SogouInput.app/Contents/Resources/symbolset.plist ~/Library/Application\ Support/Sogou/InputMethod/SogouPY/symbolset.plist
rm -rf ~/Library/Application\ Support/Sogou/InputMethod/*.pkg
rm -rf ~/Library/Application\ Support/Sogou/InputMethod/*.ins
sudo killall -KILL SystemUIServer

echo "$(date +%s) copy file : symbolset.plist" >> $LOG_PATH
echo "$(date +%s) remove pkg files and ins files" >> $LOG_PATH
echo "$(date +%s) kill process SystemUIServer" >> $LOG_PATH

exit 0
